/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.behaviour.furniture;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.math.Vector2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.NotImplementedException;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.crafting.model.CraftingRecipe;
import technology.rocketjump.undermount.entities.behaviour.ItemBehaviour;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.components.FurnitureInventoryComponent;
import technology.rocketjump.undermount.entities.components.SteeringComponent;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureLayout;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.jobs.model.CraftingType;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobState;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.EntityMessage;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.settlement.ItemTracker;

public class CraftingStationBehaviour
implements BehaviourComponent {
    private static final float WORK_TO_COMPLETE_CRAFTING = 8.0f;
    private final CraftingType craftingType;
    private final List<CraftingRecipe> craftingRecipes;
    private final ItemTracker itemTracker;
    private LocationComponent locationComponent;
    private MessageDispatcher messageDispatcher;
    private Entity parentEntity;
    private FurnitureEntityAttributes entityAttributes;
    private Random random;
    private CraftingRecipe currentlyProcessingRecipe;
    private Job craftingJob;
    private List<ItemAllocation> inputAllocations = new ArrayList<ItemAllocation>();
    private boolean outputNeedsRemoving;

    public CraftingStationBehaviour(CraftingType craftingType, List<CraftingRecipe> craftingRecipes, ItemTracker itemTracker) {
        this.craftingType = craftingType;
        this.craftingRecipes = craftingRecipes;
        this.itemTracker = itemTracker;
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        throw new NotImplementedException("Not yet implemented clone() in " + this.getClass().getSimpleName());
    }

    @Override
    public void init(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap areaMap) {
        this.parentEntity = parentEntity;
        this.entityAttributes = (FurnitureEntityAttributes)parentEntity.getPhysicalEntityComponent().getAttributes();
        this.locationComponent = parentEntity.getLocationComponent();
        this.messageDispatcher = messageDispatcher;
        this.random = new RandomXS128(this.entityAttributes.getSeed());
    }

    @Override
    public void infrequentUpdate(GameContext gameContext) {
        if (this.craftingJob != null) {
            return;
        }
        FurnitureInventoryComponent furnitureInventoryComponent = this.parentEntity.getOrCreateComponent(FurnitureInventoryComponent.class);
        if (this.outputNeedsRemoving) {
            if (furnitureInventoryComponent.isEmpty()) {
                this.outputNeedsRemoving = false;
            } else {
                return;
            }
        }
        if (this.currentlyProcessingRecipe == null) {
            this.currentlyProcessingRecipe = this.pickNextRecipe();
            if (this.currentlyProcessingRecipe == null) {
                return;
            }
            this.inputAllocations.clear();
        }
        for (QuantifiedItemType inputRequirement : this.currentlyProcessingRecipe.getInput()) {
            this.createMissingAllocationIfNeeded(inputRequirement, gameContext);
        }
    }

    public void allocationCancelled(ItemAllocation allocation) {
        this.inputAllocations.remove(allocation);
    }

    private CraftingRecipe pickNextRecipe() {
        Collections.shuffle(this.craftingRecipes, this.random);
        for (CraftingRecipe craftingRecipe : this.craftingRecipes) {
            boolean allRequirementsMet = true;
            for (QuantifiedItemType inputRequirement : craftingRecipe.getInput()) {
                boolean requirementMet = false;
                List<Entity> itemsOfType = this.itemTracker.getItemsByType(inputRequirement.getItemType(), true);
                int amountFound = 0;
                for (Entity itemEntity : itemsOfType) {
                    ItemEntityAttributes attributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                    if ((amountFound += attributes.getNumUnallocated()) < inputRequirement.getQuantity()) continue;
                    requirementMet = true;
                    break;
                }
                if (requirementMet) continue;
                allRequirementsMet = false;
                break;
            }
            if (!allRequirementsMet) continue;
            return craftingRecipe;
        }
        return null;
    }

    private void createMissingAllocationIfNeeded(QuantifiedItemType requirement, GameContext gameContext) {
        Job haulingJobForNewAllocation;
        int amountRequired = requirement.getQuantity();
        for (ItemAllocation itemAllocation : this.inputAllocations) {
            if (!itemAllocation.getItemType().equals(requirement.getItemType())) continue;
            amountRequired -= itemAllocation.getQuantity();
        }
        if (amountRequired > 0 && (haulingJobForNewAllocation = this.createNewItemAllocation(requirement, amountRequired, gameContext)) != null) {
            this.messageDispatcher.dispatchMessage(null, 609, (Object)haulingJobForNewAllocation);
        }
    }

    private Job createNewItemAllocation(QuantifiedItemType requirement, int amountRequired, GameContext gameContext) {
        Vector2 myLocation = this.locationComponent.getWorldPosition();
        List<Entity> items = this.itemTracker.getItemsByType(requirement.getItemType(), true);
        if (items != null && !items.isEmpty()) {
            Collections.sort(items, (o1, o2) -> (int)(1000.0f * (myLocation.dst2(o1.getLocationComponent().getWorldPosition()) - myLocation.dst2(o2.getLocationComponent().getWorldPosition()))));
            Iterator<Entity> iterator = items.iterator();
            if (iterator.hasNext()) {
                Entity itemEntity = iterator.next();
                ItemEntityAttributes itemAttributes = (ItemEntityAttributes)itemEntity.getPhysicalEntityComponent().getAttributes();
                int numToAllocate = Math.min(itemAttributes.getItemType().getMaxHauledAtOnce(), Math.min(amountRequired, itemAttributes.getNumUnallocated()));
                ItemAllocation allocation = new ItemAllocation();
                allocation.setTargetType(ItemAllocation.AllocationTargetType.FURNITURE);
                allocation.setTargetId(this.parentEntity.getId());
                allocation.setItemEntityId(itemEntity.getId());
                allocation.setItemType(itemAttributes.getItemType());
                allocation.setGameMaterial(itemAttributes.getMaterial(itemAttributes.getItemType().getPrimaryMaterialType()));
                allocation.setQuantity(numToAllocate);
                FurnitureLayout.Workspace workspace = this.getNavigableWorkspace(gameContext.getAreaMap());
                if (workspace == null) {
                    System.err.println("Could not find a navigable workspace to create crafting job");
                    return null;
                }
                allocation.setTargetPosition(workspace.getAccessedFrom());
                itemAttributes.setNumAllocated(itemAttributes.getNumAllocated() + numToAllocate);
                this.inputAllocations.add(allocation);
                Job haulingJob = ItemBehaviour.createHaulingJob(gameContext.getAreaMap().getTile(itemEntity.getLocationComponent().getWorldPosition()), allocation, itemEntity);
                haulingJob.setRequiredProfession(this.craftingType.getProfessionRequired());
                return haulingJob;
            }
        }
        return null;
    }

    public void itemAdded(TiledMap areaMap) {
        FurnitureInventoryComponent furnitureInventoryComponent = this.parentEntity.getOrCreateComponent(FurnitureInventoryComponent.class);
        boolean allRequirementsMet = true;
        for (QuantifiedItemType requirement : this.currentlyProcessingRecipe.getInput()) {
            boolean thisRequirementMet = false;
            int quantityInInventory = 0;
            for (Entity inventoryItem : furnitureInventoryComponent.getInventoryItems()) {
                ItemEntityAttributes itemAttributes;
                if (!inventoryItem.getType().equals((Object)EntityType.ITEM) || !(itemAttributes = (ItemEntityAttributes)inventoryItem.getPhysicalEntityComponent().getAttributes()).getItemType().equals(requirement.getItemType()) || (quantityInInventory += itemAttributes.getQuantity()) < requirement.getQuantity()) continue;
                thisRequirementMet = true;
                break;
            }
            if (thisRequirementMet) continue;
            allRequirementsMet = false;
            break;
        }
        if (allRequirementsMet) {
            Job craftingJob = new Job(JobType.CRAFT_AT_WORKSTATION);
            craftingJob.setJobState(JobState.ASSIGNABLE);
            FurnitureLayout.Workspace navigableWorkspace = this.getNavigableWorkspace(areaMap);
            if (navigableWorkspace == null) {
                System.err.println("Could not access workstation at " + this.parentEntity.getLocationComponent().getWorldPosition());
                return;
            }
            craftingJob.setJobLocation(navigableWorkspace.getAccessedFrom());
            craftingJob.setSecondaryLocation(navigableWorkspace.getLocation());
            craftingJob.setTargetEntityId(this.parentEntity.getId());
            craftingJob.setRequiredProfession(this.currentlyProcessingRecipe.getCraftingType().getProfessionRequired());
            craftingJob.setItemTypeRequiredForWork(this.currentlyProcessingRecipe.getItemTypeRequired());
            craftingJob.setTotalWorkToDo(8.0f);
            this.messageDispatcher.dispatchMessage(609, craftingJob);
            this.craftingJob = craftingJob;
        }
    }

    public void jobCompleted(ItemEntityFactory itemEntityFactory, GameContext gameContext) {
        ArrayList<Entity> output = new ArrayList<Entity>();
        FurnitureInventoryComponent inventoryComponent = this.parentEntity.getComponent(FurnitureInventoryComponent.class);
        for (QuantifiedItemType outputRequirement : this.currentlyProcessingRecipe.getOutput()) {
            ItemEntityAttributes outputAttributes = new ItemEntityAttributes(gameContext.getRandom().nextLong());
            outputAttributes.setItemType(outputRequirement.getItemType());
            outputAttributes.setItemPlacement(ItemPlacement.ON_GROUND);
            for (GameMaterialType materialTypeToCopy : this.currentlyProcessingRecipe.getMaterialTypesToCopyOver()) {
                Entity inventoryEntity;
                ItemEntityAttributes inventoryAttributes;
                GameMaterial materialToAdd = null;
                Iterator<Entity> iterator = inventoryComponent.getInventoryItems().iterator();
                while (iterator.hasNext() && (materialToAdd = (inventoryAttributes = (ItemEntityAttributes)(inventoryEntity = iterator.next()).getPhysicalEntityComponent().getAttributes()).getMaterial(materialTypeToCopy)) == null) {
                }
                if (materialToAdd == null) continue;
                outputAttributes.setMaterial(materialToAdd);
            }
            outputAttributes.setQuantity(outputRequirement.getQuantity());
            outputAttributes.setNumAllocated(outputRequirement.getQuantity());
            Entity outputItem = itemEntityFactory.create(outputAttributes, null, gameContext.getAreaMap());
            this.messageDispatcher.dispatchMessage(700, outputItem);
            output.add(outputItem);
            Job collectItemJob = new Job(JobType.COLLECT_ITEM);
            collectItemJob.setTargetEntityId(outputItem.getId());
            FurnitureLayout.Workspace navigableWorkspace = this.getNavigableWorkspace(gameContext.getAreaMap());
            collectItemJob.setJobLocation(navigableWorkspace.getAccessedFrom());
            collectItemJob.setJobState(JobState.ASSIGNABLE);
            collectItemJob.setRequiredProfession(this.craftingJob.getRequiredProfession());
            this.messageDispatcher.dispatchMessage(609, collectItemJob);
        }
        for (Entity entity : inventoryComponent.getInventoryItems()) {
            this.messageDispatcher.dispatchMessage(322, new EntityMessage(entity.getId()));
        }
        inventoryComponent.setItems(output);
        this.craftingJob = null;
        this.currentlyProcessingRecipe = null;
        this.inputAllocations.clear();
        this.outputNeedsRemoving = true;
    }

    private FurnitureLayout.Workspace getNavigableWorkspace(TiledMap areaMap) {
        GridPoint2 furniturePosition = VectorUtils.toGridPoint(this.locationComponent.getWorldPosition());
        for (FurnitureLayout.Workspace workspace : this.entityAttributes.getCurrentLayout().getWorkspaces()) {
            GridPoint2 accessedFromLocation = furniturePosition.cpy().add(workspace.getAccessedFrom());
            MapTile accessedFromTile = areaMap.getTile(accessedFromLocation);
            if (accessedFromTile == null || !accessedFromTile.isNavigable()) continue;
            FurnitureLayout.Workspace worldPositionedWorkspace = new FurnitureLayout.Workspace();
            worldPositionedWorkspace.setLocation(furniturePosition.cpy().add(workspace.getLocation()));
            worldPositionedWorkspace.setAccessedFrom(furniturePosition.cpy().add(workspace.getAccessedFrom()));
            return worldPositionedWorkspace;
        }
        return null;
    }

    @Override
    public void update(float deltaTime, TiledMap areaMap) {
    }

    @Override
    public boolean isUpdateEveryFrame() {
        return false;
    }

    @Override
    public boolean isUpdateInfrequently() {
        return true;
    }

    @Override
    public boolean isJobAssignable() {
        return false;
    }

    @Override
    public SteeringComponent getSteeringComponent() {
        return null;
    }
}

